/**
* \file: Server.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef DIPO_SERVER_H
#define DIPO_SERVER_H

#include <memory>
#include <map>
#include "AirPlayHeaders.h"
#include "utils/Referencable.h"
#include "ICarPlayDeviceAdapter.h"
#include "IConfiguration.h"
#include "PluginManager.h"
#include "CarPlayControlClient.h"

#define PNG_FILE_HEADER_BYTES     16
#define PNG_FILE_WIDTH_BYTES      4
#define PNG_FILE_HEIGHT_BYTES     4

namespace adit { namespace carplay
{

class Session;

class CARPLAY_HIDDEN Server : public ICarPlayDeviceReceiver,
    public Referencable<Server, AirPlayReceiverServerRef>
{
public:
    Server();
    ~Server();

    /* AirPlayPlatform implementations */
    bool Initialize();
    int Main(int argc, const char** argv);

    void SignalShutdown();

    void RemoveSession(Session& inSession);
    inline const std::list<Session*>& GetAllSessions() { return sessions; }

    inline IConfiguration* GetConfig() { return config; }
    bool UpdateDevicemap(std::string deviceId, CarPlayControllerRef inController, CarPlayDevice *deviceCarplay, bool inDeviceDiscovered);


    // interface implementation section
private:
    // AirPlayReceiverServer delegates
    static OSStatus HandleControl(AirPlayReceiverServerRef inServer, CFStringRef inCommand,
            CFTypeRef inQualifier, CFDictionaryRef inParams, CFDictionaryRef* outParams,
            void* inContext);
    static CFTypeRef HandleCopyProperty(AirPlayReceiverServerRef inServer, CFStringRef inProperty,
            CFTypeRef inQualifier, OSStatus* outErr, void* inContext);
    static OSStatus HandleSetProperty(AirPlayReceiverServerRef inServer, CFStringRef inProperty,
            CFTypeRef inQualifier, CFTypeRef inValue, void* inContext);
    static void HandleSessionCreated(AirPlayReceiverServerRef inServer,
            AirPlayReceiverSessionRef inSession, void* inContext);
    static void HandleSessionFailed(AirPlayReceiverServerRef inServer, OSStatus inReason, void * inContext);
    virtual CAEStatus StartCarPlayDeviceDiscovery();
    virtual CAEStatus StopCarPlayDeviceDiscovery();
    virtual CAEStatus ConnectDevice(const char* deviceId);
    virtual CAEStatus DeviceLeftFromAP(const char *deviceId, const char* ipAddress);
    virtual CAEStatus DisconnectDevice(const char* deviceId);
    CarPlayControllerRef SearchDevice(const char* deviceId, char **outStr);
    // private section
private:
    bool shutdownSignal;
    bool sessionCreated;
    ScreenRef mainScreen;
    std::list<Session*> sessions;
    std::unique_ptr<ICarPlayDeviceAdapter> carplayDeviceAdapter;
    std::map<std::string, CarPlayControllerRef> carplayDeviceMap;

    int widthPixels;
    int heightPixels;
    int widthMm;
    int heightMm;
    std::string uuid;
    int maxFps;
    int input;
    int primaryInputDevice;

    IDynamicConfiguration* config;
    PluginManager pluginManager;

    bool initCarPlayDeviceAdapter();

    template<class T> std::unique_ptr<T> createAdapter(const std::string& inName);

    bool IsScreenSettingsChanged();
    bool RegisterScreenSettings();
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_SERVER_H */
